/*
   This program reads one character at a time from
   standard input, shifts the character by N places
   in the ASCII table (where N is an integer command
   line argument), and then writes the new character
   to standard output.

   If standard input is the console keyboard,
   use ^z (Control-z) to denote the end of file
   (and you must use ^z at the beginning of a line!).
*/
import java.io.*;

public class FilterN
{
   public static void main(String[] args) throws IOException
   {
      // Check for a command line argument.
      int n = 1;   // default value for n
      if (args.length >= 1)
      {
         try
         {
            n = Integer.parseInt(args[0]);
         }
         catch (NumberFormatException e)
         {
            usage();
         }
      }

      int ch = System.in.read();
      while (ch != -1)
      {
         if (ch != 10 && ch != 13) // don't change CR or LF
            ch += n;
         System.out.print((char)ch);
         ch = System.in.read();
      }
   }

   // Print a helpful usage message.
   private static void usage()
   {
       System.err.println("Usage: java " + FilterN.class.getName() + " <integer value>");
       System.exit(1);
   }
}